
% It computes the classification of sub-tracks of lenght T by using the
% statistical method proposed by Briane, Vimond, Kevrann in "Adaptative
% Statistical Test to Detect Non-Brownian Diffusion from Particle
% Trajectories"
%
% INPUT 
% - TRACKS: it contains all the tracks
% - INT   : it contains (Sheet 1)  the intensity of the spots 
% - SURF  : it contains  the  area of the spots
% - T     : lenght of the sub-tracks to analyze
% - t_msd : parameter to calculate the linear regression of msd-curve on
%           [1, t_msd]
%
% OUTPUT
% - It computes the percentage of each mouvement class and the number of
%   analyzed class (see motion_classification).
% - PERCENTAGE is a string containing the percetnage of all class of
%   mouvement.
% - It performs all the outputs detailed in classification.m
%

clear all
close all
addpath('./DATA');
count=10;

%% Brownian motion simulation
%tau=.01;
tau=1;
tau_space=1;
D=100;
L=11;
% Parameters
T=L-1;
t_msd=L-1;
name={ 'brownian','confined', 'directed'};

for j=1:3
name{j}
TRACKS=simulation_motions(300,L,tau,D, name{j});

% Classification  
  model={'Stat','MSD'};
for k=1:2
  namebis=[name{j}, model{k}];
  [pourc, Resume, Dcoeff, beta]  = classification_simu(TRACKS,T, t_msd, tau, tau_space,  namebis, model{k});  
  
%  if name{j} == 'brownian' 
% % Histogram diffusion coefficient
%     x=Dcoeff;
%     step=D/100;
%     edges=[min(x):step:max(x)+1];
% 
%     fig=figure(count);
%     h1 = histogram(x, edges,'Normalization','pdf');
%     xlabel('Diffusion coefficient')
%     ylabel({'Relative Frequency'})
%     namefile = ['./RESULTATS/diffcoeff-brow-histo-' namebis '.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/diffcoeff-brow-histo-' namebis ];
%     saveas(fig, namefile2,'tif');
%     count=count+1;
%     
%     if k==2
%      % Exposant brownian
%     x=beta;
%     step=.01;
%     edges=[min(x):step:max(x)+1];
% 
%     fig=figure(count);
%     h1 = histogram(x, edges,'Normalization','pdf');
%     xlabel('Diffusion coefficient')
%     ylabel({'Relative Frequency'})
%     namefile = ['./RESULTATS/exposant-brow-histo-' namebis '.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/exposant-brow-histo-' namebis ];
%     saveas(fig, namefile2,'tif');
%     count=count+1; 
  %  end
  end
  close all
end



   
